package ga.core.evaluation;

import ga.core.individual.IIndividual;

/**
 * Interface for fitness evaluators.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IFitnessEvaluator<T extends IIndividual<T>> {

  /**
   * Evaluates the given individual.
   * 
   * @param individual
   *          Individual to evaluate.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void evaluate(T individual);
}
